<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            //
        $table->foreignId('device_type_id')->after('id')->constrained()->onDelete('cascade');
        $table->foreignId('device_family_id')->after('device_type_id')->constrained()->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            //
             $table->dropForeign(['device_type_id']);
            $table->dropColumn('device_type_id');

            $table->dropForeign(['device_family_id']);
            $table->dropColumn('device_family_id');

        });
    }
};
