<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('house_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('house_id')->constrained()->onDelete('cascade');
            $table->enum('role', ['owner', 'guest'])->default('guest');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade'); // Relación con el usuario creador
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
            $table->unique(['user_id', 'house_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('house_user');
    }
};
