<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class VariableTypeGroup extends Model
{
    use HasFactory;
        protected $fillable = ['name', 'slug'];


    protected static function booted(){
        static::creating(function ($group) {
            if (empty($group->slug)) {
                $group->slug = Str::slug($group->name);
            }
        });

        static::updating(function ($group) {
            if (empty($group->slug)) {
                $group->slug = Str::slug($group->name);
            }
        });
    }


    public function types()
    {
        return $this->hasMany(ControlVariableType::class, 'variable_group_id');
    }
}
