<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

     protected $fillable = [
        'house_id',
        'name',
        'type',
        'identifier',
        'floor',
        'description',
        'status'
    ];

    // public function house(){
    //     return $this->belongsTo(House::class);
    // }


    public function getTypeNameAttribute(): string  {
        return match($this->type) {
            'living_room' => 'Sala de estar',
            'kitchen' => 'Cocina',
            'bedroom' => 'Dormitorio',
            'bathroom' => 'Baño',
            'dining_room' => 'Comedor',
            'office' => 'Oficina',
            'garage' => 'Garaje',
            'garden' => 'Jardín',
            'other'=> 'otro',
        };
    }

    public function house()
    {
        return $this->belongsTo(\App\Models\House::class);
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }
    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
