<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeviceModel extends Model
{
    use HasFactory;

    protected $fillable = [
        'device_family_id',
        'name',
        'description',
        'icon',
        'status',
    ];

    public function family(): BelongsTo
    {
        return $this->belongsTo(DeviceFamily::class, 'device_family_id');
    }
}
