<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class DeviceFamily extends Model
{
    use HasFactory;

    protected $fillable = [
        'device_type_id',
        'name',
        'status',
    ];


     public function deviceType(): BelongsTo
    {
        return $this->belongsTo(DeviceType::class);
    }

    public function models(): HasMany
    {
        return $this->hasMany(DeviceModel::class);
    }
}
