<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeviceControl extends Model
{
    use HasFactory;

    protected $fillable = [
        'device_id',
        'name',
        'control_variable_type_id',
        'declaration',
        'permissions',
        'update_policy',
        'update_threshold',
        'sync_with',
        'start_at',
        'end_at',
        'is_voice_controlled',
        'voice_command',
        'created_by',
    ];

    protected $casts = [
        'sync_with' => 'array',
        'is_voice_controlled' => 'boolean',
        'start_at' => 'datetime',
        'end_at' => 'datetime',
    ];

    public function device()
    {
        return $this->belongsTo(Device::class);
    }

    public function variableType()
    {
        return $this->belongsTo(ControlVariableType::class, 'control_variable_type_id');
    }

   public function widgets()
    {
        return $this->belongsToMany(Widget::class, 'widget_device_controls', 'device_control_id', 'widget_id');
    }

}
