<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class Device extends Model
{
    use HasFactory;
     protected $fillable = [
        'id',
        'name',
        'device_model_id',
        'device_type_id',
        'device_family_id',
        'house_id',
        'room_id',
        'device_id',
        'secret_key',
        'created_by',
        'status',
    ];

     protected static function booted()
    {
        static::creating(function ($device) {
            // $device->id = Str::uuid(); // ID interno
            $device->device_id = Str::uuid(); // ID del dispositivo visible
            $device->secret_key = Str::random(24); // Clave secreta aleatoria
        });
    }

    public function model()
    {
        return $this->belongsTo(DeviceModel::class, 'device_model_id');
    }

     public function device_type()
    {
        return $this->belongsTo(DeviceType::class, 'device_type_id');
    }

     public function device_family()
    {
        return $this->belongsTo(DeviceFamily::class, 'device_family_id');
    }

    public function house()
    {
        return $this->belongsTo(House::class);
    }

    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    public function controls()
    {
        return $this->hasMany(DeviceControl::class);
    }

    public function deviceControls()
    {
        return $this->hasMany(\App\Models\DeviceControl::class);
    }

}
