<?php

namespace App\Http\Middleware;

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckUserStatus
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if ($user) {
            if ($user->status === 0) {
                Auth::logout();

                if ($user->hasAnyRole(['cliente', 'gerente'])) {
                    return redirect('/cliente/login')
                        ->withErrors(['email' => 'Su cuenta está deshabilitada. Contacte al administrador.']);
                } else {
                    return redirect('/admin/login')
                        ->withErrors(['email' => 'Su cuenta está deshabilitada. Contacte al administrador.']);
                }
            }

            if ($user->hasAnyRole(['cliente', 'gerente']) && $request->is('admin*')) {
                Auth::logout();
                return redirect('/cliente/login')
                    ->withErrors(['email' => 'No tiene permiso para acceder al panel admin.']);
            }
        }

        return $next($request);
    }
}
