<?php

namespace App\Filament\Resources;

use App\Filament\Resources\WidgetResource\Pages;
use App\Filament\Resources\WidgetResource\RelationManagers;
use App\Models\Widget;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Database\Eloquent\Model;


class WidgetResource extends Resource
{
    protected static ?string $model = Widget::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
     protected static ?string $navigationGroup = 'Componentes';

    protected static ?int $navigationSort = 13;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                Forms\Components\TextInput::make('name')
                    ->label('Nombre')
                    ->required()
                    ->maxLength(100),

                Forms\Components\Textarea::make('description')
                    ->label('Descripción')
                    ->rows(2)
                    ->nullable(),

                Forms\Components\Select::make('type')
                    ->label('Tipo')
                    ->options([
                        'interaction' => 'Interacción',
                        'visualization' => 'Visualización',
                        'notification' => 'Notificación',
                    ])
                    ->required()
                    ->reactive(),



                Forms\Components\TextInput::make('icon')
                    ->label('Icono')
                    ->placeholder('fa-lightbulb, mdi-thermometer')
                    ->nullable(),

                // Forms\Components\KeyValue::make('config')
                //     ->label('Configuración extra')
                //     ->keyLabel('Clave')
                //     ->valueLabel('Valor')
                //     ->nullable()
                //     ->reorderable(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
                Tables\Columns\TextColumn::make('name')
                    ->label('Nombre')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('description')
                    ->label('Descripción')
                    ->limit(40),

                Tables\Columns\TextColumn::make('type')
                    ->label('Tipo')
                    ->badge(),



                Tables\Columns\TextColumn::make('icon')
                    ->label('Icono'),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Creado')
                    ->dateTime('d/m/Y H:i'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWidgets::route('/'),
            'create' => Pages\CreateWidget::route('/create'),
            'edit' => Pages\EditWidget::route('/{record}/edit'),
        ];
    }

      public static function getPluralModelLabel(): string
    {
        return 'Componentes';
    }


    public static function canViewAny(): bool
    {
        return auth()->user()?->can('componentes.view');
    }

    public static function canCreate(): bool
    {
        return auth()->user()?->can('componentes.create');
    }

    public static function canEdit(Model $record): bool
    {
        return auth()->user()?->can('componentes.update');
    }

    public static function canDelete(Model $record): bool
    {
        return auth()->user()?->can('componentes.delete');
    }
}
