<?php

namespace App\Filament\Resources\RoleResource\Pages;

use App\Filament\Resources\RoleResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Permission;
class EditRole extends EditRecord
{
    protected static string $resource = RoleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }


    protected function mutateFormDataBeforeFill(array $data): array
{
    $groupedPermissions = Permission::all()->groupBy(function ($permission) {
        return Str::before($permission->name, '.');
    });

    foreach ($groupedPermissions as $group => $perms) {
        $selected = $this->record->permissions()
            ->whereIn('name', $perms->pluck('name'))
            ->pluck('id')
            ->toArray();

        $data["permissions_{$group}"] = $selected;
    }

    return $data;
}

protected function mutateFormDataBeforeSave(array $data): array
{
    foreach ($data as $key => $value) {
        if (Str::startsWith($key, 'permissions_')) {
            unset($data[$key]);
        }
    }

    return $data;
}
protected function afterSave(): void
{
    // 1. Obtener todos los IDs seleccionados
    $permissionIds = collect($this->form->getState())
        ->filter(fn($value, $key) => Str::startsWith($key, 'permissions_'))
        ->flatten()
        ->unique()
        ->toArray();

    // 2. Convertir los IDs a nombres de permisos
    $permissionNames = Permission::whereIn('id', $permissionIds)->pluck('name')->toArray();

    // 3. Asignar los permisos al rol usando nombres
    $this->record->syncPermissions($permissionNames);
}

protected function getRedirectUrl(): string{
        return $this->getResource()::getUrl('index');
    }

    public static function canEdit(Model $record): bool
{
    if (in_array($record->name, ['cliente'])) {
        return false;
    }
    return self::check('role.update');
}

public static function canDelete(Model $record): bool
{
    if (in_array($record->name, ['cliente'])) {
        return false;
    }
    return self::check('role.delete');
}
}
