<?php

namespace App\Filament\Resources\RoleResource\Pages;

use App\Filament\Resources\RoleResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Permission;

class CreateRole extends CreateRecord
{
    protected static string $resource = RoleResource::class;


    protected function mutateFormDataBeforeCreate(array $data): array
    {
        foreach ($data as $key => $value) {
            if (Str::startsWith($key, 'permissions_')) {
                unset($data[$key]);
            }
        }

        return $data;
    }

    protected function afterCreate(): void
    {
        $permissionIds = collect($this->form->getState())
            ->filter(fn($value, $key) => Str::startsWith($key, 'permissions_'))
            ->flatten()
            ->unique()
            ->toArray();

        $permissionNames = Permission::whereIn('id', $permissionIds)
            ->pluck('name')
            ->toArray();

        if (!empty($permissionNames)) {
            $this->record->syncPermissions($permissionNames);
        }
    }

    protected function getRedirectUrl(): string{
        return $this->getResource()::getUrl('index');
    }
}
