<?php

namespace App\Filament\Resources\HouseResource\Pages;

use App\Filament\Resources\HouseResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditHouse extends EditRecord
{
    protected static string $resource = HouseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('inactivar')
                ->label('Eliminar')
                ->icon('heroicon-o-trash')
                ->requiresConfirmation()
                ->color('danger')
                ->action(function () {
                    $record = $this->getRecord();
                    $record->status = 'inactive';
                    $record->save();

                    $this->redirect(HouseResource::getUrl());
                }),
        ];
    }

    protected function getRedirectUrl(): string{
        return $this->getResource()::getUrl('index');
    }

    public function getTitle(): string
    {
        return 'Editar Hogar';
    }





}
