<?php

namespace App\Filament\Resources\DeviceResource\Pages;

use App\Filament\Resources\DeviceResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditDevice extends EditRecord
{
    protected static string $resource = DeviceResource::class;

    // protected function getHeaderActions(): array
    // {
    //     return [
    //         Actions\DeleteAction::make(),
    //     ];
    // }


    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('inactivar')
                ->label('Eliminar')
                ->icon('heroicon-o-trash')
                ->requiresConfirmation()
                ->color('danger')
                ->action(function () {
                    $record = $this->getRecord();
                    $record->created_by = auth()->id();
                    $record->status = 0;
                    $record->save();
                    $this->redirect(DeviceResource::getUrl());
                }),
        ];
    }

    protected function getRedirectUrl(): string{
        return $this->getResource()::getUrl('index');
    }

    public function getTitle(): string
    {
        return 'Editar Microcontrolador';
    }
}
