<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DeviceModelResource\Pages;
use App\Filament\Resources\DeviceModelResource\RelationManagers;
use App\Models\DeviceModel;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Database\Eloquent\Model;


class DeviceModelResource extends Resource
{
    protected static ?string $model = DeviceModel::class;

    protected static ?string $navigationIcon = 'heroicon-o-inbox';
    protected static ?string $navigationGroup = 'Configuración de Dispositivos';

    protected static ?int $navigationSort = 10;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                Forms\Components\Select::make('device_family_id')
                ->label('Familia')
                ->relationship('family', 'name')
                ->required(),

            Forms\Components\TextInput::make('name')
                ->label('Nombre del Modelo')
                ->required(),

            Forms\Components\Textarea::make('description')
                ->label('Descripción')
                ->maxLength(500),

            Forms\Components\TextInput::make('icon')
                ->label('Ícono')
                ->placeholder('fa-microchip o nombre_de_imagen.png'),

            Forms\Components\Toggle::make('status')
                ->label('Activo')
                ->default(true),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
                 Tables\Columns\TextColumn::make('family.name')->label('Familia'),
                Tables\Columns\TextColumn::make('name')->label('Modelo'),
                Tables\Columns\IconColumn::make('status')->boolean()->label('Estado'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDeviceModels::route('/'),
            'create' => Pages\CreateDeviceModel::route('/create'),
            'edit' => Pages\EditDeviceModel::route('/{record}/edit'),
        ];
    }

    public static function getPluralModelLabel(): string
    {
        return 'Modelo dispositivos';
    }


    public static function canViewAny(): bool
    {
        return auth()->user()?->can('modelo_dispositivo.view');
    }

    public static function canCreate(): bool
    {
        return auth()->user()?->can('modelo_dispositivo.create');
    }

    public static function canEdit(Model $record): bool
    {
        return auth()->user()?->can('modelo_dispositivo.update');
    }

    public static function canDelete(Model $record): bool
    {
        return auth()->user()?->can('modelo_dispositivo.delete');
    }
}
