<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DeviceFamilyResource\Pages;
use App\Filament\Resources\DeviceFamilyResource\RelationManagers;
use App\Models\DeviceFamily;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class DeviceFamilyResource extends Resource
{
    protected static ?string $model = DeviceFamily::class;
    protected static ?string $navigationGroup = 'Configuración de Dispositivos';
    protected static ?int $navigationSort = 9;


    protected static ?string $navigationIcon = 'heroicon-o-inbox-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                 Forms\Components\Select::make('device_type_id')
                ->label('Tipo de dispositivo')
                ->relationship('deviceType', 'name')
                ->required(),

            Forms\Components\TextInput::make('name')
                ->label('Nombre')
                ->required()
                ->maxLength(255),

            Forms\Components\Textarea::make('description')
                ->label('Descripción')
                ->maxLength(500),

            Forms\Components\TextInput::make('icon')
                ->label('Ícono (clase o imagen)')
                ->placeholder('fa-microchip o esp32.png'),

            Forms\Components\Toggle::make('status')
                ->label('Activo')
                ->default(true),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
                Tables\Columns\TextColumn::make('deviceType.name')->label('Tipo'),
                Tables\Columns\TextColumn::make('name')->label('Familia'),
                Tables\Columns\TextColumn::make('description')->limit(30)->label('Descripción'),
                Tables\Columns\IconColumn::make('status')->boolean()->label('Estado'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDeviceFamilies::route('/'),
            'create' => Pages\CreateDeviceFamily::route('/create'),
            'edit' => Pages\EditDeviceFamily::route('/{record}/edit'),
        ];
    }

    public static function getPluralModelLabel(): string
    {
        return 'Familia dispositivos';
    }

    public static function shouldRegisterNavigation(): bool
    {
        return false;
    }
}
