<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DeviceControlResource\Pages;
use App\Filament\Resources\DeviceControlResource\RelationManagers;
use App\Models\DeviceControl;
use App\Models\Widget;
use App\Models\WidgetDeviceControl;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Database\Eloquent\Model;


class DeviceControlResource extends Resource
{
    protected static ?string $model = DeviceControl::class;
protected static ?string $navigationIcon = 'heroicon-o-device-phone-mobile';

    protected static ?string $navigationGroup = 'Dispositivos Registrados';


    protected static ?int $navigationSort = 8;
    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                Forms\Components\Select::make('device_id')
                    ->label('Dispositivo')
                    ->options(\App\Models\Device::pluck('name', 'id'))
                    ->required(),

                Forms\Components\TextInput::make('name')
                    ->label('Nombre del control')
                    ->required()
                    ->afterStateUpdated(fn ($state, callable $set, Forms\Get $get) =>
                        static::updateDeclaration($set, $get)
                    ),


                Forms\Components\Select::make('control_variable_type_id')
                    ->label('Tipo de variable')
                    ->options(\App\Models\ControlVariableType::pluck('name', 'id'))
                    ->searchable()
                    ->required()
                    ->reactive()
                    ->afterStateUpdated(fn ($state, callable $set, Forms\Get $get) =>
                        static::updateDeclaration($set, $get)
                    ),

                Forms\Components\Textarea::make('declaration')
                    ->label('Declaración')
                    ->maxLength(255)
                    ->nullable()
                    ->reactive()
                    ->disabled()
                    ->dehydrated(fn (Forms\Get $get) => filled($get('declaration')))
                    ->afterStateHydrated(function (Forms\Components\Textarea $component, $state, Forms\Get $get) {
                            if (!$state && $get('name') && $get('control_variable_type_id')) {
                                    $type = \App\Models\ControlVariableType::find($get('control_variable_type_id'));
                                    if ($type) {
                                                $component->state("{$type->slug} {$get('name')};");
                                        }
                                    }
                        }),

                // Forms\Components\Select::make('permissions')
                //     ->label('Permisos')
                //     ->options([
                //         'read_write' => 'Leer y escribir',
                //         'read_only' => 'Solo lectura',
                //     ])
                //     ->default('read_write'),

                // Forms\Components\Select::make('update_policy')
                //     ->label('Política de actualización')
                //     ->options([
                //         'on_change' => 'Sobre el cambio',
                //         'periodic' => 'Periódicamente',
                //     ])
                //     ->default('on_change'),

                // Forms\Components\TextInput::make('update_threshold')
                //     ->label('Intervalo (segundos)')
                //     ->numeric()
                //     ->nullable(),

               Forms\Components\KeyValue::make('sync_with')
                    ->label('Sincronizar con')
                    ->keyLabel('Clave')
                    ->valueLabel('Valor')
                    ->nullable()
                    ->reorderable()
                    ->helperText('Opciones dinámicas de variables asociadas para este control'),


                Forms\Components\Select::make('widgets')
                    ->label('Widgets asociados')
                    ->relationship('widgets', 'name')
                    ->preload()
                    ->helperText('Selecciona los widgets que controlará este dispositivo'),



                // Forms\Components\DateTimePicker::make('start_at')->label('Inicio')->nullable(),
                // Forms\Components\DateTimePicker::make('end_at')->label('Fin')->nullable(),

                // Forms\Components\TextInput::make('voice_command')->label('Comando de voz')->nullable(),
                // Forms\Components\Toggle::make('is_voice_controlled')->label('Control por voz'),

                Forms\Components\Hidden::make('created_by')
                    ->default(auth()->id()),

                        ]);


    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //

                Tables\Columns\TextColumn::make('device.name')
                    ->label('Dispositivo')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('name')
                    ->label('Nombre')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('variableType.name')
                    ->label('Tipo de variable'),

                Tables\Columns\TextColumn::make('declaration')
                    ->label('Declaración de variable')
                    ->limit(40)
                    ->copyable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDeviceControls::route('/'),
            'create' => Pages\CreateDeviceControl::route('/create'),
            'edit' => Pages\EditDeviceControl::route('/{record}/edit'),
        ];
    }

    protected static function updateDeclaration(callable $set, Forms\Get $get)
    {
        $name = $get('name');
        $typeId = $get('control_variable_type_id');

        if ($name && $typeId) {
            $type = \App\Models\ControlVariableType::find($typeId);
            if ($type) {
                $set('declaration', "{$type->slug} {$name};");
            }
        }
    }

     public static function canViewAny(): bool
    {
        return auth()->user()?->can('dispositivo_control.controls.view');
    }

    public static function canCreate(): bool
    {
        return auth()->user()?->can('dispositivo_control.controls.create');
    }

    public static function canEdit(Model $record): bool
    {
        return auth()->user()?->can('dispositivo_control.controls.update');
    }

    public static function canDelete(Model $record): bool
    {
        return auth()->user()?->can('dispositivo_control.controls.delete');
    }

     public static function getPluralModelLabel(): string
    {
        return 'Control dispositivos';
    }


}



