<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ControlVariableTypeResource\Pages;
use App\Filament\Resources\ControlVariableTypeResource\RelationManagers;
use App\Models\ControlVariableType;
use App\Models\VariableTypeGroup;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ControlVariableTypeResource extends Resource
{
    protected static ?string $model = ControlVariableType::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Dispositivos Registrados';

    protected static ?int $navigationSort = 12;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //

             Forms\Components\Select::make('variable_group_id')
                    ->label('Grupo de Variable')
                    ->options(VariableTypeGroup::pluck('name', 'id'))
                    ->searchable()
                    ->required(),

                Forms\Components\TextInput::make('name')
                    ->label('Nombre')
                    ->required()
                    ->maxLength(50),


                Forms\Components\TextInput::make('unit')
                    ->label('Unidad (opcional)')
                    ->maxLength(10),

                Forms\Components\TextInput::make('example')
                    ->label('Ejemplo (opcional)')
                    ->maxLength(50),

                Forms\Components\Textarea::make('description')
                    ->label('Descripción')
                    ->rows(3),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
                Tables\Columns\TextColumn::make('group.name')->label('Tipo de variables')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('name')->label('Nombre')->searchable(),
                Tables\Columns\TextColumn::make('unit')->label('Unidad'),
                Tables\Columns\TextColumn::make('example')->label('Ejemplo'),
                Tables\Columns\TextColumn::make('description')->label('Descripción')->limit(40),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListControlVariableTypes::route('/'),
            'create' => Pages\CreateControlVariableType::route('/create'),
            'edit' => Pages\EditControlVariableType::route('/{record}/edit'),
        ];
    }

    public static function shouldRegisterNavigation(): bool
    {
        return false;
    }
}
