<?php

namespace App\Filament\Cliente\Pages;

use Filament\Pages\Page;
use App\Models\House;

class HouseRooms extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-home';
    protected static string $view = 'filament.cliente.pages.house-rooms';

    public $house;
    public $rooms = [];

    public function mount($houseId)
    {
        // Buscar la casa por ID
        $this->house = House::findOrFail($houseId);

        // Traer los nombres de los ambientes
        $this->rooms = $this->house->rooms()->pluck('name')->toArray();
    }
}
