<?php

namespace App\Filament\Cliente\Widgets;

use Filament\Widgets\Widget;
use App\Models\HouseUser;
use App\Models\House;

class ClientePanel extends Widget
{
    protected static string $view = 'filament.cliente.widgets.cliente-panel';

    public $homes = [];

     public function mount(): void
    {
        $user = auth()->user();
        if ($user) {
            $this->homes = $user->houses()->with('rooms')->get()->map(function($house){
                return [
                    'name' => $house->name,
                    'rooms' => $house->rooms->pluck('name')->toArray(),
                ];
            })->toArray();
        }
    }
}






